<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$servername = "ivepos-db-production-regular.mysql.database.azure.com";
$username = "iveposadmin";
$password = "Intuition123";
$dbname_ivepos_license = "ivepos_license";
$dbname_ivepos_license_retail = "ivepos_license_retail";

$project_type = $_POST['project_type'] ?? '';

$conn1 = new mysqli($servername, $username, $password, $dbname_ivepos_license);
$conn2 = new mysqli($servername, $username, $password, $dbname_ivepos_license_retail);

if ($conn1->connect_error || $conn2->connect_error) {
    die("Connection failed: " . $conn1->connect_error . " | " . $conn2->connect_error);
}

$sql1 = "SELECT id, company, email FROM company";
$sql2 = $sql1;

$result1 = $conn1->query($sql1);
$result2 = $conn2->query($sql2);

if ($result1 === false || $result2 === false) {
    $data = [
        "status" => "failed",
        "message" => "Query execution failed"
    ];
} else {
    $combinedRecords = [];

    while ($row1 = $result1->fetch_assoc()) {
        $row1['business_type'] = "Dine";
        $companyid = $row1['id'];

        // Calculate counts for dine
        $dine_counts_sql = "SELECT 
                                SUM(CASE WHEN expirydate > NOW() THEN 1 ELSE 0 END) AS active_licenses,
                                SUM(CASE WHEN expirydate <= NOW() THEN 1 ELSE 0 END) AS expired_licenses,
                                SUM(CASE WHEN expirydate BETWEEN DATE_SUB(NOW(), INTERVAL 90 DAY) AND NOW() THEN 1 ELSE 0 END) AS expiring_last_90_days,
                                SUM(CASE WHEN expirydate BETWEEN NOW() AND DATE_ADD(NOW(), INTERVAL 90 DAY) THEN 1 ELSE 0 END) AS expiring_next_90_days
                            FROM device WHERE companyid = ?";
        $stmt = $conn1->prepare($dine_counts_sql);
        $stmt->bind_param("i", $companyid);
        $stmt->execute();
        $dine_counts_result = $stmt->get_result();
        $dine_counts = $dine_counts_result->fetch_assoc();
        $row1['dine_counts'] = $dine_counts;

        $combinedRecords[] = $row1;
    }

    while ($row2 = $result2->fetch_assoc()) {
        $row2['business_type'] = "Retail";
        $companyid = $row2['id'];

        // Calculate counts for retail
        $retail_counts_sql = "SELECT 
                                SUM(CASE WHEN expirydate > NOW() THEN 1 ELSE 0 END) AS active_licenses,
                                SUM(CASE WHEN expirydate <= NOW() THEN 1 ELSE 0 END) AS expired_licenses,
                                SUM(CASE WHEN expirydate BETWEEN DATE_SUB(NOW(), INTERVAL 90 DAY) AND NOW() THEN 1 ELSE 0 END) AS expiring_last_90_days,
                                SUM(CASE WHEN expirydate BETWEEN NOW() AND DATE_ADD(NOW(), INTERVAL 90 DAY) THEN 1 ELSE 0 END) AS expiring_next_90_days
                            FROM device WHERE companyid = ?";
        $stmt = $conn2->prepare($retail_counts_sql);
        $stmt->bind_param("i", $companyid);
        $stmt->execute();
        $retail_counts_result = $stmt->get_result();
        $retail_counts = $retail_counts_result->fetch_assoc();
        $row2['retail_counts'] = $retail_counts;

        $combinedRecords[] = $row2;
    }

    $data = [
        "status" => "success",
        "message" => "",
        "records" => $combinedRecords
    ];
}

header('Content-Type: application/json');
echo json_encode($data, JSON_PRETTY_PRINT);

$conn1->close();
$conn2->close();
?>
